#!/usr/bin/python2
# -*- coding: utf-8 -*-

import sys
import os
import logging

from fabric.tasks import execute
from fabric.api import env, run
from fabric.operations import put, get

from datetime import datetime


PONTO_DB = """$TTL 14400
__domain_name__.pege.com.br.      86400   IN      SOA     ns1.infatec.net.br.     abuse.infatec.net.br.   (
                                                __date__01 ;Serial Number
                                                3600 ;refresh
                                                7200 ;retry
                                                1209600 ;expire
                                                86400 ;minimum
        )
__domain_name__.pege.com.br.      86400   IN      NS      ns1.infatec.net.br.
__domain_name__.pege.com.br.      86400   IN      NS      ns2.infatec.net.br.
__domain_name__.pege.com.br.      14400   IN      A       __droplet_ip__
__domain_name__.pege.com.br.      14400   IN      A       __droplet_ip__
mail    14400   IN      CNAME   __domain_name__.pege.com.br.
www     14400   IN      CNAME   __domain_name__.pege.com.br.
ftp     14400   IN      A       __droplet_ip__
cpanel  14400   IN      A       __droplet_ip__
webdisk 14400   IN      A       __droplet_ip__
cpcalendars     14400   IN      A       209.126.103.85
cpcontacts      14400   IN      A       209.126.103.85
whm     14400   IN      A       209.126.103.85
webmail 14400   IN      A       209.126.103.85
"""

ZONE = '};\n\n\nzone "__domain_name__.pege.com.br" {\n\ttype ' +\
    'master;\n\tfile "/var/named/__file_db_name__";\n};\n\n};'


logging.getLogger(
    'paramiko.transport'
).addHandler(
    logging.StreamHandler()
)

env.hosts = [
    '209.126.103.85:38652'
]
env.user = 'root'


def altera_named(domain_name, file_db_name):
    local_named_path = os.path.join(os.getcwd(), 'named.conf')

    named_file = open(local_named_path, 'r')
    named_content = named_file.read()
    named_file.close()

    if file_db_name in named_content:
        raise Exception('Domínio já existe no servidor DNS!')

    text_to_replace = "};\n\n};"

    named_content = named_content.replace(
        text_to_replace,
        ZONE.replace(
            '__domain_name__', domain_name
        ).replace(
            '__file_db_name__', file_db_name
        )
    )

    named_file = open(local_named_path, 'w')
    named_file.write(named_content)
    named_file.close()
    return local_named_path


def cria_arquivo_db(file_db_name):
    file_path = os.path.join(os.getcwd(), file_db_name)
    file_db = open(file_path, 'w')

    file_db.write(
        PONTO_DB.replace('__domain_name__', domain_name)
                .replace('__droplet_ip__', droplet_ip)
                .replace('__date__', datetime.now().strftime("%Y%m%d"))
    )

    file_db.close()

    return file_path


def exec_add_domain(domain_name, droplet_ip):
    server_named_path = "/etc/named.conf"
    path_db = '/var/named/'
    file_db_name = "%s.pege.com.br.db" % domain_name

    # Pegando arquivo named.conf do servidor
    result = get(server_named_path, os.path.join(os.getcwd(), 'named.conf'))
    if result.failed:
        raise Exception('Erro ao tentar copiar arquivo named.conf do servidor.')

    # Alterando arquivo named.conf
    local_named_path = altera_named(domain_name, file_db_name)

    # Criando arquivo .db
    file_db_path = cria_arquivo_db(file_db_name)

    # Enviando arquivo .db para o servidor
    result = put(local_path=file_db_path, remote_path=path_db)

    if result.failed:
        raise Exception('Erro ao adicionar arquivo "%s" ao servidor DNS.' % file_db_name)

    os.remove(file_db_path)

    # Realizando backup do arquivo named.conf no servidor
    result = run(
        "mv {} {}.{}".format(
            server_named_path,
            server_named_path,
            datetime.now().strftime("%Y%m%d%S")
        )
    )

    if result.failed:
        raise Exception('Erro ao realizar backup do arquivo named.conf no servidor.')

    # Enviando arquivo novo named.conf para o servidor
    result = put(local_path=local_named_path, remote_path=server_named_path)

    if result.failed:
        raise Exception('Erro ao enviar novo arquivo named.conf para o servidor.')

    os.remove(local_named_path)

    # Definindo dono e grupo do arquivo named.conf e reiniciando serviço
    result = run(
        "chown named:named {} && chown named:named {} && rndc reload".format(
            os.path.join(path_db, file_db_name),
            server_named_path
        )
    )

    if result.failed:
        raise Exception('Erro ao realizar chown no arquivo e/ou reiniciar o serviço.')


if __name__ == '__main__':
    try:
        domain_name = sys.argv[1]
        droplet_ip = sys.argv[2]
        execute(exec_add_domain, domain_name, droplet_ip)
        print 'Sucesso ao executar script para criação do domínio "{}".'.format(domain_name)
    except Exception as err:
        msg = "Erro ao executar comando! (%s)" % err
        print msg
