#!/usr/bin/python2
# -*- coding: utf-8 -*-

import os
import sys
import logging

from fabric.api import env, run
from fabric.tasks import execute


logging.getLogger(
    'paramiko.transport'
).addHandler(
    logging.StreamHandler()
)

env.hosts = [
    os.environ.get('MANAGER_HOST')
]
env.user = os.environ.get('MANAGER_HOST_USER')
env.password = os.environ.get('MANAGER_HOST_PASSWORD')


def exec_add_domain(domain_name, droplet_ip):
    script_path = "django_apps/DIARIO_MANAGER/scripts/add_domain.py"
    result = run("chmod +x %s && %s %s %s" % (script_path, script_path, domain_name, droplet_ip))
    if result.failed:
        print "Erro ao executar script de criação de domínio. (%s)" % result.command
    print "Criação de domínio executada com sucesso."


if __name__ == '__main__':
    try:
        domain_name = sys.argv[1]
        droplet_ip = sys.argv[2]
        return execute(exec_add_domain, domain_name, droplet_ip)
    except Exception as err:
        msg = "Erro ao executar comando! (%s)" % err
        print msg
