from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from solo.models import SingletonModel


class Cliente(models.Model):
    """Model definition for Cliente."""

    # Informações do cliente
    nome = models.CharField(max_length=50)
    domain_name = models.CharField(max_length=50, unique=True)
    email = models.EmailField(max_length=70)
    username = models.CharField(max_length=50)
    password = models.CharField(max_length=50)

    # Informações do droplet
    droplet_id = models.CharField(max_length=50, blank=True, null=True)

    class Meta:
        """Meta definition for Cliente."""
        verbose_name = 'Cliente'
        verbose_name_plural = 'Clientes'

    def __str__(self):
        """Representação da classe na forma de String"""
        return '{} - {}.{}'.format(
            self.nome.title(),
            self.domain_name,
            settings.BASE_DOMAIN
        )


class Configuracoes(SingletonModel):
    token = models.CharField(max_length=255)
    droplets_region = models.CharField(_('Região dos Droplets'), max_length=50)
    droplets_image = models.CharField(_('Imagem/SO dos Droplets'), max_length=50)
    droplets_size = models.CharField(_('Tamanho dos Droplets'), max_length=50)
    droplets_ssh_keys = models.TextField(blank=True)
    droplets_backups = models.BooleanField(default=False)
    droplets_ipv6 = models.BooleanField(default=True)
    user_data = models.TextField(blank=True)

    def __str__(self):
        return "Configurações"

    class Meta:
        verbose_name = "Configurações"
