from django.contrib import admin
from django.conf import settings

from django.utils.translation import ugettext_lazy as _

from solo.admin import SingletonModelAdmin

from .models import Configuracao
from .models import Cliente
from .models import ChaveSSH


class ClienteAdmin(admin.ModelAdmin):
    list_display = ('__str__', 'email', 'droplet_ip', 'droplet_status')
    list_display_links = ('__str__', 'email')
    search_fields = ('nome', 'domain_name', 'email', 'username')
    list_per_page = 25


admin.site.site_tile = _(settings.SITE_TITLE)
admin.site.site_header = _(settings.SITE_HEADER)

admin.site.register(Configuracao, SingletonModelAdmin)
admin.site.register(Cliente, ClienteAdmin)
admin.site.register(ChaveSSH)
