import digitalocean

from django import forms
from django.contrib import admin
from django.conf import settings

from django.utils.translation import ugettext_lazy as _

from solo.admin import SingletonModelAdmin

from .models import Configuracao
from .models import Cliente
from .models import ChaveSSH
from .models import Sistema


class ClienteForm(forms.ModelForm):

    droplets_size = forms.ChoiceField()

    class Meta:
        model = Cliente
        fields = "__all__"

    def __init__(self, *args, **kwargs):
        super(ClienteForm, self).__init__(*args, **kwargs)
        manager = digitalocean.Manager(token = Configuracao.get_solo().token)
        self.fields['droplets_size'].choices = [(val, val) for val in manager.get_all_sizes()]
    

    def clean_subdomain_name(self):
        data = self.cleaned_data['subdomain_name']
        self.username_subdomain_name_clean(data)
        return data

    def clean_username(self):
        data = self.cleaned_data['username']
        self.username_subdomain_name_clean(data)
        return data

    def username_subdomain_name_clean(self, data):
        if not data.isalnum() and not data.replace('_', '').isalnum() and not data.replace('-', '').isalnum():
            raise forms.ValidationError('Somente letras, números, "_" e "-".')
        if data.lower() != data:
            raise forms.ValidationError('Somente letras minúsculas.')


class ClienteAdmin(admin.ModelAdmin):
    list_display = ('__str__', 'email', 'droplet_ip', 'droplet_status')
    list_display_links = ('__str__', 'email')
    search_fields = ('nome', 'subdomain_name', 'email', 'username')
    list_per_page = 25
    form = ClienteForm


admin.site.site_tile = _(settings.SITE_TITLE)
admin.site.site_header = _(settings.SITE_HEADER)

admin.site.register(Configuracao, SingletonModelAdmin)
admin.site.register(Cliente, ClienteAdmin)
admin.site.register(ChaveSSH)
admin.site.register(Sistema)
