from rest_framework.views import APIView
from rest_framework.response import Response
from backend.core.models import Cliente
from backend.api.serializers import *
from rest_framework.exceptions import APIException


class ListClientes(APIView):
    """
    View para listar todos os clientes.

    * Requires token authentication.
    * Only admin users are able to access this view.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)

    def get(self, request, format=None):
        """
        Retorna uma lista de todos os Clientes.

        """
        lista_clientes = Cliente.objects.all()
        return Response(ClienteSerializer(lista_clientes, many=True).data)
