from decouple import config

from dj_database_url import parse as db_url

from unipath import Path

# Title of admin site
SITE_TITLE = config('SITE_TITLE', default='Administração Infatec')

# Header os admin site
SITE_HEADER = config('SITE_HEADER', default='Administração Infatec')

# Base Domain
#BASE_DOMAIN = config('BASE_DOMAIN', default='diariodigital.pege.com.br') movido para o model de Sistema


# Base directory of projetc
BASE_DIR = Path(__file__).ancestor(2)

DEBUG = config('DEBUG', default=False, cast=bool)

# Active Apps
INSTALLED_APPS = [
    # Django built-in apps
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',

    # Apps de terceiros
    'solo',
    'django_rq',
    'rest_framework',

    # Local apps
    'backend.core',
    'backend.api'
]

if DEBUG:
    INSTALLED_APPS.insert(0, 'django_extensions')


MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',

    # Third-party middlewares
    # 'whitenoise.middleware.WhiteNoiseMiddleware',
]

# Url and GateWay Config
ROOT_URLCONF = 'backend.urls'
SITE_ID = 1
WSGI_APPLICATION = 'backend.wsgi.application'

# RQ (Redis Queue)
# http://python-rq.org/

RQ_QUEUES = {
    'default': {
        'URL': config('REDIS_URL', default='redis://redis/0'),
    }
}

RQ = {
    'host': 'redis',
    'db': 0,
}

# Database
DATABASES = {
    'default': config(
        'DATABASE_URL',
        cast=db_url
    ),
}

# Internationalization
LANGUAGE_CODE = 'pt-br'
TIME_ZONE = 'America/Fortaleza'
USE_I18N = True
USE_L10N = True
USE_TZ = False
USE_THOUSAND_SEPARATOR = True
DATE_INPUT_FORMATS = ('%d-%m-%Y', '%Y-%m-%d')

# Login Configs
# LOGIN_URL = '/login/'
# LOGOUT_URL = '/logout/'
# LOGIN_REDIRECT_URL = '/'
