from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from backend.core.tasks import create_droplet_pipeline


class Cliente(models.Model):
    """Model definition for Cliente."""

    # Informações do cliente
    nome = models.CharField(max_length=50)
    domain_name = models.CharField(max_length=50, unique=True)
    email = models.EmailField(max_length=70)
    username = models.CharField(max_length=50)
    password = models.CharField(max_length=50)

    # Informações do droplet
    droplet_id = models.CharField(_('id do droplet'), max_length=50, blank=True, null=True)

    class Meta:
        """Meta definition for Cliente."""
        verbose_name = 'Cliente'
        verbose_name_plural = 'Clientes'

    def __str__(self):
        """Representação da classe na forma de String"""
        return '{} - {}.{}'.format(
            self.nome.title(),
            self.domain_name,
            settings.BASE_DOMAIN
        )

    def save(self, *args, **kwargs):
        adding = self._state.adding
        super().save(*args, **kwargs)

        if adding:
            create_droplet_pipeline(self)
