from django.http import JsonResponse

from backend.core.models import Cliente


def cliente_droplet_status(request, domain):
    data = {}
    if request.method == 'GET':
        if domain is not None:
            cliente = Cliente.objects.get(domain_name=domain)
            data['result'] = {
                'status': cliente.droplet_status,
                'ip': cliente.droplet_ip
            }
        else:
            data['result'] = 'Nenhum domínio enviado.'
    else:
        data['result'] = 'Método incorreto.'
    return JsonResponse(data)
