#!/usr/bin/python2
# -*- coding: utf-8 -*-

import os
import sys
import logging

from fabric.api import env, run, settings, show, hide
from fabric.tasks import execute


logging.getLogger(
    'paramiko.transport'
).addHandler(
    logging.StreamHandler()
)

env.hosts = [
    os.environ.get('MANAGER_HOST')
]
env.user = os.environ.get('MANAGER_HOST_USER')
env.password = os.environ.get('MANAGER_HOST_PASSWORD')


def exec_add_domain(domain_name):
    script_path = "django_apps/DIARIO_MANAGER/scripts/add_domain.py"
    with settings(hide('everything'), show('running')):
        result = run("chmod +x %s && %s %s" % (script_path, script_path, domain_name))
        if result.failed:
            return "Erro ao executar script de criação de domínio. (%s)" % result.command
        return "Erro ao executar script de criação de domínio"


if __name__ == '__main__':
    try:
        domain_name = sys.argv[1]
        execute(exec_add_domain, domain_name)
    except Exception as err:
        msg = "Erro ao executar comando! (%s)" % err
        print msg
