from django.db import models
from django.utils.translation import ugettext_lazy as _

from solo.models import SingletonModel

from .chave_ssh import ChaveSSH


class Configuracao(SingletonModel):
    """Model definition for COnfigurations"""
    token = models.CharField(max_length=255)

    chave_ssh = models.TextField(blank=True)

    droplets_region = models.CharField(_('Região dos Droplets'), max_length=50, default="nyc1")
    droplets_image = models.CharField(_('Imagem/SO dos Droplets'), max_length=50, default="ubuntu-16-04-x64")
    droplets_size = models.CharField(_('Tamanho dos Droplets'), max_length=50, default="s-1vcpu-1gb")
    droplets_backups = models.BooleanField(default=False)
    droplets_ipv6 = models.BooleanField(default=False)
    droplets_user_data = models.TextField(blank=True)

    def __str__(self):
        """String representations for configuration"""
        return "Configurações"

    class Meta:
        """Meta definition for configuration"""
        verbose_name = "Configurações"

    @property
    def ssh_keys(self):
        chaves = ChaveSSH.objects.values('chave_ssh')
        if chaves:
            return [c['chave_ssh'] for c in chaves]
        return None
