from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

import django_rq


class Sistema(models.Model):
    """Model definition for Sistema."""
    # Informações do cliente
    nome = models.CharField(max_length=50)
    domain_name = models.CharField(_('Domínio'), max_length=50, unique=True)
    droplets_user_data = models.TextField(blank=True)

    class Meta:
        """Meta definition for Sistema."""
        verbose_name = 'Sistema'
        verbose_name_plural = 'Sistemas'

    def __str__(self):
        """Representação da classe na forma de String"""
        return '{} - {} - {}'.format(
            self.nome.title(),
            self.domain_name,
            self.droplets_user_data
        )
