#!/usr/bin/python2
# -*- coding: utf-8 -*-

import os
import sys
import logging

from fabric.tasks import execute
from fabric.api import env, run


logging.getLogger(
    'paramiko.transport'
).addHandler(
    logging.StreamHandler()
)

# Definindo dados do MANAGER para acesso remoto.
env.hosts = [
    os.environ.get('MANAGER_HOST')
]
env.user = os.environ.get('MANAGER_HOST_USER')
env.password = os.environ.get('MANAGER_HOST_PASSWORD')


def exec_add_domain(subdomain_name, domain_name, droplet_ip):
    """
    Função para acessar o servidor MANAGER e iniciar o script que adicionará
    o novo subdomínio ao servidor DNS.

    :param subdomain_name: Nome do subdomínio
    :type subdomain_name: str
    :param droplet_ip: O subdomínio apontará para este IP
    :type droplet_ip: str
    :returns:
    """
    script_path = "django_apps/DIARIO_MANAGER/scripts/add_domain.py"
    result = run("chmod +x %s && %s %s %s %s" % (script_path, script_path, subdomain_name, domain_name, droplet_ip))
    if result.failed:
        raise Exception("Erro ao executar script de criação de domínio. (%s)" % result.command)


def main():
    try:
        subdomain_name = sys.argv[1]
        domain_name = sys.argv[2]
        droplet_ip = sys.argv[3]
        execute(exec_add_domain, subdomain_name, domain_name, droplet_ip)
        print "Criação de domínio executada com sucesso."
    except Exception as err:
        msg = "Erro ao executar comando! (%s)" % err
        print msg


if __name__ == '__main__':
    main()
