#!/usr/bin/env python
import os
import sys

from dotenv import load_dotenv

if __name__ == "__main__":

    debug = os.environ.get('DEBUG')

    if not debug:
        dotenv_path = os.path.join(os.path.dirname(__file__), 'config.env')
        load_dotenv(dotenv_path)
    
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "settings")
    
    try:
        from django.core.management import execute_from_command_line
    except ImportError as exc:
        raise ImportError(
            "Couldn't import Django. Are you sure it's installed and "
            "available on your PYTHONPATH environment variable? Did you "
            "forget to activate a virtual environment?"
        ) from exc
    execute_from_command_line(sys.argv)
